<?php
/*
Plugin Name: Trapz DL Card
Description: Displays a driver's license-style card for the logged-in user.
Version: 1.0
Author: Jones Lawson
*/

// Enqueue the necessary styles and scripts
function trapz_dl_card_enqueue_styles() {
    wp_enqueue_style('trapz-dl-card-style', plugin_dir_url(__FILE__) . 'style.css');
}
add_action('wp_enqueue_scripts', 'trapz_dl_card_enqueue_styles');

// Create a shortcode to display the DL card
function trapz_dl_card_shortcode($atts) {
    // Get the current user's information
    $user_id = get_current_user_id();
    $user_info = get_userdata($user_id);

    // Generate a random DL number, issue date, and expiration date
    $dl_number = 'DL-' . mt_rand(100000000, 999999999); // Random 9-digit number
    $issue_date = date('m/d/Y', mt_rand(strtotime('01/01/2018'), strtotime('12/31/2023')));
    $expiration_date = date('m/d/Y', mt_rand(strtotime('01/01/2024'), strtotime('12/31/2028')));

    // Use the user's profile image and full name
    $profile_image_url = get_avatar_url($user_id);
    $full_name = $user_info->display_name;

    // Fixed date of birth and address
    $date_of_birth = '01/01/1990';
    $address = '123 Main St, City, State';

    // Define the HTML for the DL card with the requested background color
    $output = "<div id='driver-license' style='background-color: #16705A;'>";
    $output .= "<div id='photo'><img class='rounded-avatar' src='$profile_image_url' alt='Profile Image'></div>";
    $output .= "<h4>$full_name</h4>";
    $output .= "<p>Date of Birth: $date_of_birth</p>";
    $output .= "<p>Address: $address</p>";
    $output .= "<p>Issued: $issue_date</p>";
    $output .= "<p>Expires: $expiration_date</p>";
    $output .= "<div id='barcode'>$dl_number</div>";
    $output .= "</div>";

    return $output;
}
add_shortcode('trapz_dl_card', 'trapz_dl_card_shortcode');