<?php
/*
Plugin Name: Trapz Credit Number Generator
Description: Generate random 16-digit credit numbers and 3-digit CVV numbers for registered users with correct spacing.
Version: 1.0
Author: Jones Lawson
Plugin URI: https://hollyscripts.com/  // Add your official website URL here
*/

// Function to generate and save the credit number and CVV for a user
function generate_credit_and_cvv_numbers($user_id) {
    // Generate a random 12-digit number for credit number.
    $random_credit_part = str_pad(mt_rand(0, 999999999999), 12, '0', STR_PAD_LEFT);

    // Combine it with the fixed first 4 digits and add correct spacing.
    $credit_number = '4474 ' . substr($random_credit_part, 0, 4) . ' ' . substr($random_credit_part, 4, 4) . ' ' . substr($random_credit_part, 8, 4);

    // Generate a random 3-digit CVV number.
    $cvv_number = str_pad(mt_rand(0, 999), 3, '0', STR_PAD_LEFT);

    // Update the user's metadata with the generated credit number and CVV.
    update_user_meta($user_id, 'credit_number', $credit_number);
    update_user_meta($user_id, 'cvv_number', $cvv_number);
}

// Function to generate credit and CVV numbers for all existing users
function generate_credit_and_cvv_numbers_for_existing_users() {
    $users = get_users(); // Get a list of all users

    foreach ($users as $user) {
        $user_id = $user->ID;
        // Generate and save the credit and CVV numbers for each user.
        generate_credit_and_cvv_numbers($user_id);
    }
}

// Hook into user registration for new users
add_action('user_register', 'generate_credit_and_cvv_numbers');

// Hook into an admin page for generating credit and CVV numbers for existing users
add_action('admin_menu', 'add_generate_credit_and_cvv_numbers_page');

function add_generate_credit_and_cvv_numbers_page() {
    add_menu_page(
        'Generate Credit and CVV Numbers',
        'Generate Credit and CVV Numbers',
        'manage_options',
        'generate-credit-cvv-numbers',
        'generate_credit_and_cvv_numbers_for_existing_users'
    );
}

// Function to display the credit number using a shortcode
function display_credit_number() {
    // Get the current user's credit number.
    $current_user = wp_get_current_user();
    $credit_number = get_user_meta($current_user->ID, 'credit_number', true);

    if (!empty($credit_number)) {
        return $credit_number;
    } else {
        return 'Credit number not found.';
    }
}
add_shortcode('credit_numbers', 'display_credit_number');

// Function to display the CVV number using a shortcode
function display_cvv_number() {
    // Get the current user's CVV number.
    $current_user = wp_get_current_user();
    $cvv_number = get_user_meta($current_user->ID, 'cvv_number', true);

    if (!empty($cvv_number)) {
        return $cvv_number;
    } else {
        return 'CVV number not found.';
    }
}
add_shortcode('cvv_numbers', 'display_cvv_number');