<?php
/*
Plugin Name: Trapz Admin Approve
Description: Require admin approval for new user registrations, specifically for the 'Subscriber' role.
Author: Your Name
Version: 1.0
*/

if (!defined('ABSPATH')) exit; // Exit if accessed directly

// Hook for adding admin menus
add_action('admin_menu', 'trapz_admin_approve_menu');

function trapz_admin_approve_menu() {
    add_users_page('Approve Users', 'Approve Users', 'promote_users', 'trapz-admin-approve', 'trapz_admin_approve_page');
}

function trapz_admin_approve_page() {
    if (!current_user_can('promote_users')) {
        wp_die(__('You do not have sufficient permissions to access this page.'));
    }

    if (isset($_GET['approve'])) {
        $user_id = intval($_GET['approve']);
        $user_info = get_userdata($user_id);

        if (in_array('subscriber', (array) $user_info->roles)) {
            update_user_meta($user_id, 'trapz_admin_approved', 'true');
            trapz_send_approval_email($user_id); // Send approval email
        }
    }

    $users = get_users(array('role' => 'subscriber', 'meta_key' => 'trapz_admin_approved', 'meta_value' => 'false'));

    echo '<h2>Approve Users</h2>';
    
    if ($users) {
        echo '<ul>';
        foreach ($users as $user) {
            echo '<li>' . esc_html($user->user_login) . ' - <a href="' . esc_url(add_query_arg('approve', $user->ID)) . '">Approve</a></li>';
        }
        echo '</ul>';
    } else {
        echo '<p>No users awaiting approval.</p>';
    }
}

function trapz_send_approval_email($user_id) {
    $user_info = get_userdata($user_id);
    $user_display_name = $user_info->display_name;
    $site_name = get_bloginfo('name');
    $site_email = get_bloginfo('admin_email');

    $subject = 'Exciting News! Your Bank Account Opening Request is Approved!';
    $message = "Dear {$user_display_name},\n\n";
    $message .= "I trust this message finds you in great spirits. We are thrilled to share some fantastic news with you! Your recent request to open a bank account with us has been approved, and we couldn't be more delighted to welcome you to the {$site_name} family.\n\n";
    $message .= "Your trust in {$site_name} means a great deal to us, and we are genuinely excited to embark on this banking journey together. Our team is committed to providing you with top-notch service and a seamless banking experience.\n\n";
    $message .= "Thanks for choosing {$site_name} as your preferred banking partner. We are confident that you'll find our services to be tailored to meet your financial needs and expectations.\n\n";
    $message .= "Should you have any questions or require assistance, please don't hesitate to reach out to our dedicated customer service team. We are here to ensure your banking experience is nothing short of excellent.\n\n";
    $message .= "Once again, thank you for entrusting us with your banking needs. We look forward to serving you and building a lasting relationship.\n\n";
    $message .= "Warm regards,\n\n";
    $message .= "Jones Hoogerbrugge\n";
    $message .= "Risk Management Department\n";
    $message .= $site_email;

    wp_mail($user_info->user_email, $subject, $message);
}

add_action('user_register', 'trapz_on_user_register', 10, 1);

function trapz_on_user_register($user_id) {
    $user_info = get_userdata($user_id);

    if (in_array('subscriber', (array) $user_info->roles)) {
        update_user_meta($user_id, 'trapz_admin_approved', 'false');
    }
}

function trapz_is_user_approved($user_id) {
    return get_user_meta($user_id, 'trapz_admin_approved', true) === 'true';
}

add_filter('authenticate', 'trapz_check_user_approval', 30, 3);

function trapz_check_user_approval($user, $username, $password) {
    if (is_a($user, 'WP_User')) {
        if (in_array('subscriber', (array) $user->roles) && !trapz_is_user_approved($user->ID)) {
            return new WP_Error('not_approved', __('Your account has to be approved by an administrator before you can log in.', 'trapz'));
        }
    }

    return $user;
}

register_activation_hook(__FILE__, 'trapz_admin_approve_activate');

function trapz_admin_approve_activate() {
    // Code to run on activation
}

register_deactivation_hook(__FILE__, 'trapz_admin_approve_deactivate');

function trapz_admin_approve_deactivate() {
    // Code to run on deactivation
}
?>
