<?php
/*
Plugin Name: Trapz Account Generator
Description: Generate 12-digit account numbers and display the last three digits using shortcodes.
Version: 1.0
Author: Jones Lawson
Author URI: http://hollyscripts.com
*/

function generate_account_number($length = 12) {
    $account_number = '';
    for ($i = 0; $i < $length; $i++) {
        $account_number .= rand(0, 9);
    }
    return $account_number;
}

function get_or_generate_account_number($key, $length = 12) {
    $user_id = get_current_user_id();
    $user_key = $key . '_' . $user_id;
    $account_number = get_transient($user_key);

    if (empty($account_number)) {
        $account_number = generate_account_number($length);
        set_transient($user_key, $account_number, 0); // Store in transient for the current user's session
    }

    return $account_number;
}

function trapz_checking_12_shortcode() {
    return get_or_generate_account_number('trapz_checking_account', 12);
}

function trapz_savings_12_shortcode() {
    return get_or_generate_account_number('trapz_savings_account', 12);
}

function trapz_checking_last3_shortcode() {
    $account_number = get_or_generate_account_number('trapz_checking_account', 12);
    return substr($account_number, -3);
}

function trapz_savings_last3_shortcode() {
    $account_number = get_or_generate_account_number('trapz_savings_account', 12);
    return substr($account_number, -3);
}

add_shortcode('trapz_checking_12', 'trapz_checking_12_shortcode');
add_shortcode('trapz_savings_12', 'trapz_savings_12_shortcode');
add_shortcode('trapz_checking_last3', 'trapz_checking_last3_shortcode');
add_shortcode('trapz_savings_last3', 'trapz_savings_last3_shortcode');