<?php
/*
Plugin Name: Hide Plugins from Admins
Description: Hides all plugins from administrators, only visible to Super Admin.
Version: 1.0
Author: Jones Lawson Trapz
*/

// Hook for admin_menu to remove the plugins menu
function hide_plugins_from_admins_menu() {
    if (!current_user_can('manage_network')) { // Checks if user is not a super admin
        remove_menu_page('plugins.php'); // Removes the plugins menu item
    }
}
add_action('admin_menu', 'hide_plugins_from_admins_menu');

// Optional: Hide plugins from the plugins list as well
function hide_plugins_from_admins_list($plugins) {
    if (!current_user_can('manage_network')) { // Checks if user is not a super admin
        return []; // Return an empty array to hide all plugins
    }
    return $plugins; // Return the original plugins list for super admins
}
add_filter('all_plugins', 'hide_plugins_from_admins_list');