<?php
/**
 * Plugin Name: Custom Registration Form
 * Description: Custom registration form with extended fields, email confirmation, and profile picture as default avatar.
 * Version: 1.0
 * Author: Your Name
 */

// Enqueue necessary scripts and styles
function custom_registration_form_scripts() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'custom_registration_form_scripts');

// Shortcode for displaying the registration form
function custom_registration_form_shortcode() {
    if (is_user_logged_in()) {
        return '<p>You are already registered and logged in!</p>';
    }

    ob_start(); ?>
    <form action="<?php echo esc_url($_SERVER['REQUEST_URI']) ?>" method="post" enctype="multipart/form-data" class="custom-registration-form">
        <p>
            <label for="firstname">First Name</label>
            <input type="text" name="firstname" id="firstname">
        </p>
        <p>
            <label for="lastname">Last Name</label>
            <input type="text" name="lastname" id="lastname">
        </p>
        <p>
            <label for="username">Username <strong>*</strong></label>
            <input type="text" name="username" id="username" required>
        </p>
        <p>
            <label for="email">Email <strong>*</strong></label>
            <input type="email" name="email" id="email" required>
        </p>
        <p>
            <label for="password">Password <strong>*</strong></label>
            <input type="password" name="password" id="password" required>
        </p>
        <p>
            <label for="profile_picture">Profile Picture</label>
            <input type="file" name="profile_picture" id="profile_picture">
        </p>
		<p>
    <label for="ssn">SSN</label>
    <input type="text" name="ssn" id="ssn">
</p>
<p>
    <label for="dl_front">Driver's License (Front)</label>
    <input type="file" name="dl_front" id="dl_front">
</p>
<p>
    <label for="dl_back">Driver's License (Back)</label>
    <input type="file" name="dl_back" id="dl_back">
</p>
        <p>
            <label for="address">Address</label>
            <input type="text" name="address" id="address">
        </p>
        <p>
            <label for="zipcode">Zip Code</label>
            <input type="text" name="zipcode" id="zipcode">
        </p>
        <p>
            <label for="country">Country</label>
<select name="country" id="country">
    <option value="afghanistan">Afghanistan</option>
    <option value="albania">Albania</option>
    <option value="algeria">Algeria</option>
    <option value="andorra">Andorra</option>
    <option value="angola">Angola</option>
    <option value="antigua_and_barbuda">Antigua and Barbuda</option>
    <option value="argentina">Argentina</option>
    <option value="armenia">Armenia</option>
    <option value="australia">Australia</option>
    <option value="austria">Austria</option>
    <option value="azerbaijan">Azerbaijan</option>
    <option value="bahamas">Bahamas</option>
    <option value="bahrain">Bahrain</option>
    <option value="bangladesh">Bangladesh</option>
    <option value="barbados">Barbados</option>
    <option value="belarus">Belarus</option>
    <option value="belgium">Belgium</option>
    <option value="belize">Belize</option>
    <option value="benin">Benin</option>
    <option value="bhutan">Bhutan</option>
    <option value="bolivia">Bolivia</option>
    <option value="bosnia_and_herzegovina">Bosnia and Herzegovina</option>
    <option value="botswana">Botswana</option>
    <option value="brazil">Brazil</option>
    <option value="brunei">Brunei</option>
    <option value="bulgaria">Bulgaria</option>
    <option value="burkina_faso">Burkina Faso</option>
    <option value="burundi">Burundi</option>
    <option value="cabo_verde">Cabo Verde</option>
    <option value="cambodia">Cambodia</option>
    <option value="cameroon">Cameroon</option>
    <option value="canada">Canada</option>
    <option value="central_african_republic">Central African Republic</option>
    <option value="chad">Chad</option>
    <option value="chile">Chile</option>
    <option value="china">China</option>
    <option value="colombia">Colombia</option>
    <option value="comoros">Comoros</option>
    <option value="congo_republic">Congo Republic</option>
    <option value="costa_rica">Costa Rica</option>
    <option value="cote_d_ivoire">Côte d'Ivoire</option>
    <option value="croatia">Croatia</option>
    <option value="cuba">Cuba</option>
    <option value="cyprus">Cyprus</option>
    <option value="czech_republic">Czech Republic</option>
    <option value="democratic_republic_of_the_congo">Democratic Republic of the Congo</option>
    <option value="denmark">Denmark</option>
    <option value="djibouti">Djibouti</option>
    <option value="dominica">Dominica</option>
    <option value="dominican_republic">Dominican Republic</option>
    <option value="ecuador">Ecuador</option>
    <option value="egypt">Egypt</option>
    <option value="el_salvador">El Salvador</option>
    <option value="equatorial_guinea">Equatorial Guinea</option>
    <option value="eritrea">Eritrea</option>
    <option value="estonia">Estonia</option>
    <option value="eswatini">Eswatini</option>
    <option value="ethiopia">Ethiopia</option>
    <option value="fiji">Fiji</option>
    <option value="finland">Finland</option>
    <option value="france">France</option>
    <option value="gabon">Gabon</option>
    <option value="gambia">Gambia</option>
    <option value="georgia">Georgia</option>
    <option value="germany">Germany</option>
    <option value="ghana">Ghana</option>
    <option value="greece">Greece</option>
    <option value="grenada">Grenada</option>
    <option value="guatemala">Guatemala</option>
    <option value="guinea">Guinea</option>
    <option value="guinea_bissau">Guinea-Bissau</option>
    <option value="guyana">Guyana</option>
    <option value="haiti">Haiti</option>
    <option value="honduras">Honduras</option>
    <option value="hungary">Hungary</option>
    <option value="iceland">Iceland</option>
    <option value="india">India</option>
    <option value="indonesia">Indonesia</option>
    <option value="iran">Iran</option>
    <option value="iraq">Iraq</option>
    <option value="ireland">Ireland</option>
    <option value="israel">Israel</option>
    <option value="italy">Italy</option>
    <option value="jamaica">Jamaica</option>
    <option value="japan">Japan</option>
    <option value="jordan">Jordan</option>
    <option value="kazakhstan">Kazakhstan</option>
    <option value="kenya">Kenya</option>
    <option value="kiribati">Kiribati</option>
    <option value="kosovo">Kosovo</option>
    <option value="kuwait">Kuwait</option>
    <option value="kyrgyzstan">Kyrgyzstan</option>
    <option value="laos">Laos</option>
    <option value="latvia">Latvia</option>
    <option value="lebanon">Lebanon</option>
    <option value="lesotho">Lesotho</option>
    <option value="liberia">Liberia</option>
    <option value="libya">Libya</option>
    <option value="liechtenstein">Liechtenstein</option>
    <option value="lithuania">Lithuania</option>
    <option value="luxembourg">Luxembourg</option>
    <option value="madagascar">Madagascar</option>
    <option value="malawi">Malawi</option>
    <option value="malaysia">Malaysia</option>
    <option value="maldives">Maldives</option>
    <option value="mali">Mali</option>
    <option value="malta">Malta</option>
    <option value="marshall_islands">Marshall Islands</option>
    <option value="mauritania">Mauritania</option>
    <option value="mauritius">Mauritius</option>
    <option value="mexico">Mexico</option>
    <option value="micronesia">Micronesia</option>
    <option value="moldova">Moldova</option>
    <option value="monaco">Monaco</option>
    <option value="mongolia">Mongolia</option>
    <option value="montenegro">Montenegro</option>
    <option value="morocco">Morocco</option>
    <option value="mozambique">Mozambique</option>
    <option value="myanmar">Myanmar</option>
    <option value="namibia">Namibia</option>
    <option value="nauru">Nauru</option>
    <option value="nepal">Nepal</option>
    <option value="netherlands">Netherlands</option>
    <option value="new_zealand">New Zealand</option>
    <option value="nicaragua">Nicaragua</option>
    <option value="niger">Niger</option>
    <option value="nigeria">Nigeria</option>
    <option value="north_korea">North Korea</option>
    <option value="north_macedonia">North Macedonia</option>
    <option value="norway">Norway</option>
    <option value="oman">Oman</option>
    <option value="pakistan">Pakistan</option>
    <option value="palau">Palau</option>
    <option value="palestine">Palestine</option>
    <option value="panama">Panama</option>
    <option value="papua_new_guinea">Papua New Guinea</option>
    <option value="paraguay">Paraguay</option>
    <option value="peru">Peru</option>
    <option value="philippines">Philippines</option>
    <option value="poland">Poland</option>
    <option value="portugal">Portugal</option>
	<option value="qatar">Qatar</option>
<option value="romania">Romania</option>
<option value="russia">Russia</option>
<option value="rwanda">Rwanda</option>
<option value="saint_kitts_and_nevis">Saint Kitts and Nevis</option>
<option value="saint_lucia">Saint Lucia</option>
<option value="saint_vincent_and_the_grenadines">Saint Vincent and the Grenadines</option>
<option value="samoa">Samoa</option>
<option value="san_marino">San Marino</option>
<option value="sao_tome_and_principe">Sao Tome and Principe</option>
<option value="saudi_arabia">Saudi Arabia</option>
<option value="senegal">Senegal</option>
<option value="serbia">Serbia</option>
<option value="seychelles">Seychelles</option>
<option value="sierra_leone">Sierra Leone</option>
<option value="singapore">Singapore</option>
<option value="slovakia">Slovakia</option>
<option value="slovenia">Slovenia</option>
<option value="solomon_islands">Solomon Islands</option>
<option value="somalia">Somalia</option>
<option value="south_africa">South Africa</option>
<option value="south_korea">South Korea</option>
<option value="south_sudan">South Sudan</option>
<option value="spain">Spain</option>
<option value="sri_lanka">Sri Lanka</option>
<option value="sudan">Sudan</option>
<option value="suriname">Suriname</option>
<option value="sweden">Sweden</option>
<option value="switzerland">Switzerland</option>
<option value="syria">Syria</option>
<option value="tajikistan">Tajikistan</option>
<option value="tanzania">Tanzania</option>
<option value="thailand">Thailand</option>
<option value="timor_leste">Timor-Leste</option>
<option value="togo">Togo</option>
<option value="tonga">Tonga</option>
<option value="trinidad_and_tobago">Trinidad and Tobago</option>
<option value="tunisia">Tunisia</option>
<option value="turkey">Turkey</option>
<option value="turkmenistan">Turkmenistan</option>
<option value="tuvalu">Tuvalu</option>
<option value="uganda">Uganda</option>
<option value="ukraine">Ukraine</option>
<option value="united_arab_emirates">United Arab Emirates</option>
<option value="united_kingdom">United Kingdom</option>
<option value="united_states">United States</option>
<option value="uruguay">Uruguay</option>
<option value="uzbekistan">Uzbekistan</option>
<option value="vanuatu">Vanuatu</option>
<option value="vatican_city">Vatican City</option>
<option value="venezuela">Venezuela</option>
<option value="vietnam">Vietnam</option>
<option value="yemen">Yemen</option>
<option value="zambia">Zambia</option>
<option value="zimbabwe">Zimbabwe</option>
</select>

        </p>
        <p>
            <input type="submit" name="submit" value="Open Account">
        </p>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('custom_registration_form', 'custom_registration_form_shortcode');

// Handling the form submission
function custom_registration_form_handle_post() {
    if (isset($_POST['submit'])) {
        // Sanitize and assign form inputs
        $username = sanitize_user($_POST['username']);
        $password = esc_attr($_POST['password']);
        $email = sanitize_email($_POST['email']);
        $firstname = sanitize_text_field($_POST['firstname']);
        $lastname = sanitize_text_field($_POST['lastname']);
        $address = sanitize_text_field($_POST['address']);
        $zipcode = sanitize_text_field($_POST['zipcode']);
        $country = sanitize_text_field($_POST['country']);
        $ssn = sanitize_text_field($_POST['ssn']);

        // Create the user
        $user_id = wp_create_user($username, $password, $email);

        if (!is_wp_error($user_id)) {
            // Update user meta information
            update_user_meta($user_id, 'first_name', $firstname);
            update_user_meta($user_id, 'last_name', $lastname);
            update_user_meta($user_id, 'address', $address);
            update_user_meta($user_id, 'zipcode', $zipcode);
            update_user_meta($user_id, 'country', $country);
            update_user_meta($user_id, 'ssn', $ssn);

            // Handle file uploads for DL front and back
            $dl_front_id = custom_handle_upload('dl_front');
            $dl_back_id = custom_handle_upload('dl_back');
            update_user_meta($user_id, 'dl_front', $dl_front_id);
            update_user_meta($user_id, 'dl_back', $dl_back_id);

            // Handle profile picture upload
            if (isset($_FILES['profile_picture']) && $_FILES['profile_picture']['error'] == UPLOAD_ERR_OK) {
                require_once(ABSPATH . 'wp-admin/includes/image.php');
                require_once(ABSPATH . 'wp-admin/includes/file.php');
                require_once(ABSPATH . 'wp-admin/includes/media.php');

                $profile_picture_id = media_handle_upload('profile_picture', 0);

                if (!is_wp_error($profile_picture_id)) {
                    update_user_meta($user_id, 'wp_user_avatar', $profile_picture_id);
                }
            }

            // Send the welcome email
            $subject = 'Welcome to ' . get_bloginfo('name');
            $message .= "Greetings from " . get_bloginfo('name') . "!\n\n";
            $message .= "Thank you for taking the first step towards a seamless banking experience with us. We have received your account opening application and are currently in the process of carefully reviewing the information you provided.\n\n";
            $message .= "Our dedicated team is working diligently to ensure that all details are thoroughly examined, and your application is processed with the utmost care. Please be assured that we understand the importance of your request and are committed to delivering a banking experience that exceeds your expectations.\n\n";
            $message .= "While your application is under review, we kindly ask for your patience. This meticulous review process is a crucial step in providing you with the best service possible.\n\n";
            $message .= "Rest assured, you will be notified promptly once the review is complete. If we require any additional information or documentation to finalize the process, our team will reach out to you directly.\n\n";
            $message .= "We appreciate your trust in " . get_bloginfo('name') . ", and we look forward to welcoming you as a valued member of our banking community.\n\n";
            $message .= "If you have any questions or concerns in the meantime, please feel free to contact our customer support team at " . get_bloginfo('admin_email') . ".\n\n";
            $message .= "Thank you for choosing " . get_bloginfo('name') . ".";
            wp_mail($email, $subject, $message);

            // Redirect to the account page
            wp_redirect(home_url('/welcome/'));
            exit;
        }
    }
}
add_action('init', 'custom_registration_form_handle_post');

// Utility function for handling file uploads
function custom_handle_upload($input_name) {
    if (isset($_FILES[$input_name]) && $_FILES[$input_name]['error'] == UPLOAD_ERR_OK) {
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once(ABSPATH . 'wp-admin/includes/media.php');
        
        $attachment_id = media_handle_upload($input_name, 0);
        return is_wp_error($attachment_id) ? null : $attachment_id;
    }
    return null;
}

// Replace the default avatar with user's profile picture
function custom_avatar($avatar, $id_or_email, $size, $default, $alt) {
    $user = false;

    if (is_numeric($id_or_email)) {
        $user = get_user_by('id', $id_or_email);
    } elseif (is_object($id_or_email) && !empty($id_or_email->user_id)) {
        $user = get_user_by('id', $id_or_email->user_id);
    } else {
        $user = get_user_by('email', $id_or_email);
    }

    if ($user && is_object($user)) {
        $profile_picture_id = get_user_meta($user->ID, 'wp_user_avatar', true);
        if ($profile_picture_id) {
            $avatar_url = wp_get_attachment_image_src($profile_picture_id, [$size, $size])[0];
            return "<img alt='{$alt}' src='{$avatar_url}' class='avatar avatar-{$size} photo' height='{$size}' width='{$size}' />";
        }
    }

    return $avatar;
}
add_filter('get_avatar', 'custom_avatar', 1, 5);


function custom_registration_form_styles() {
    ?>
   <style>
    /* Basic Styles for the Registration Form */
    .custom-registration-form {
        max-width: 600px;
        margin: 0 auto;
        padding: 20px;
        background-color: #16705A; /* Form background color */
        border: 1px solid #ddd;
        border-radius: 4px;
        color: white; /* Set default text color to white */
    }

    .custom-registration-form label {
        display: block;
        margin-bottom: 5px;
        font-weight: bold;
        color: white; /* Label text color */
    }

    .custom-registration-form input[type="text"],
    .custom-registration-form input[type="email"],
    .custom-registration-form input[type="password"],
    .custom-registration-form select,
    .custom-registration-form input[type="file"] {
        width: 100%;
        padding: 8px;
        margin-bottom: 15px;
        border: 1px solid #ddd;
        border-radius: 4px;
        background-color: white; /* Input field background color */
        color: black; /* Input text color */
    }

    .custom-registration-form input[type="submit"] {
        background-color: #38C660; /* Submit button color */
        color: white;
        padding: 10px 15px;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        font-size: 16px;
    }

    .custom-registration-form input[type="submit"]:hover {
        background-color: #32b14a; /* Darker shade for button hover */
    }

    /* Responsive Styles */
    @media (max-width: 600px) {
        .custom-registration-form {
            padding: 10px;
        }
    }
</style>

    <?php
}
add_action('wp_head', 'custom_registration_form_styles');