<?php

if ( ! class_exists( 'Openexchange_api_settings' ) ) {

	class Openexchange_api_settings {

		private static $instance;

		public static function init() {
			if ( empty( self::$instance ) ) {
				return self::$instance = new self();
			}
			return self::$instance;
		}

		public function init_hooks() {
			add_action( 'admin_notices', array( $this, 'openexchange_api_key_notice' ) );
			add_action( 'admin_menu', array( $this, 'openexchange_add_submenu' ), 100 );
			add_action( 'admin_init', array( $this, 'openexchange_settings' ) );
			add_action( 'admin_head', array( $this, 'openexchange_custom_js' ) );
		}

		public function openexchange_custom_js() {
			 wp_enqueue_script( 'jquery' );

			$script = "
            <script>
                jQuery(document).ready(function($){
                    var url = window.location.href;
                    if (url.indexOf('?page=openexchange-api-settings') > 0) {
                        $('[href=\"admin.php?page=openexchange-api-settings\"]').parent('li').addClass('current');
                    }
                    var data = $('#adminmenu #toplevel_page_cool-crypto-plugins ul li a[href=\"admin.php?page=openexchange-api-settings\"]');
                    data.each(function(e){
                        if ($(this).is(':empty')) {
                            $(this).hide();
                        }
                    });
                    $('#ccpw_dismiss_notice button.notice-dismiss').on('click', function (event) {
                        var notice_data = $('#ccpw_dismiss_notice');
                        $(notice_data).slideUp();
                    });
                });
            </script>
            ";

			echo $script;
		}

		public function openexchange_add_submenu() {
			add_submenu_page( 'cool-crypto-plugins', 'Open Exchange API', 'Open Exchange API', 'manage_options', 'openexchange-api-settings', array( $this, 'openexchange_settings_callback' ), 100 );
		}

		public function openexchange_settings() {
			register_setting(
				'Openexchange_option_group',
				'openexchange-api-settings'
			);

			add_settings_section(
				'Openexchange_section_id',
				'Open Exchange Rates API',
				array( $this, 'openexchange_section_option' ),
				'openexchange-api-settings'
			);

			add_settings_field( 'Api_key', 'Enter API Key', array( $this, 'api_key_fun' ), 'openexchange-api-settings', 'Openexchange_section_id' );
		}

		public function openexchange_section_option() {
			 echo '<div class="ccew_api_setting_section">ENTER OPEN EXCHANGE RATES API KEY</div>';
		}

		public function api_key_fun() {
			 $api_option = get_option( 'openexchange-api-settings' );
			$apikey      = ( ! empty( $api_option['openexchangerate_api'] ) ) ? $api_option['openexchangerate_api'] : '';

			echo '<input type="text" name="openexchange-api-settings[openexchangerate_api]" size="35" value="' . esc_attr( $apikey ) . '"><br><br>Click Here To <a href="https://openexchangerates.org/signup/free" target="_blank">Get Openexchangerates Free API Key</a>';
		}

		public function openexchange_settings_callback() {          ?>
			<?php settings_errors(); ?>
			<form method="post" action="options.php">
				<?php settings_fields( 'Openexchange_option_group' ); ?>
				<?php do_settings_sections( 'openexchange-api-settings' ); ?>
				<?php submit_button(); ?>
			</form>
			<?php
		}

		public function openexchange_api_key_notice() {
			 $api_option = get_option( 'openexchange-api-settings' );
			$api         = ( ! empty( $api_option['openexchangerate_api'] ) ) ? $api_option['openexchangerate_api'] : '';

			if ( ! current_user_can( 'delete_posts' ) || ! empty( $api ) ) {
				return;
			}

			$current_user = wp_get_current_user();
			$user_name    = $current_user->display_name;
			$ajax_url     = admin_url( 'admin-ajax.php' );
			?>
			<div class="license-warning notice notice-error is-dismissible" id="ccpw_dismiss_notice">
				<p>Hi, <strong><?php echo ucwords( $user_name ); ?></strong>! Please <strong><a href="<?php echo esc_url( get_admin_url( null, 'admin.php?page=openexchange-api-settings' ) ); ?>">enter</a></strong> Open Exchange Rates.org free API key for crypto to fiat price conversions.</p>
				<button type="button" class="notice-dismiss"><span class="screen-reader-text">Dismiss this notice.</span></button>
			</div>
			<?php
		}
	}

	$openexchange = Openexchange_api_settings::init();
	$openexchange->init_hooks();
}
