<?php
/*
Plugin Name: BTC Plugin with Credit Card and BTC Withdraw
Description: A simple BTC token management plugin with credit card deposit and BTC withdrawal.
Version: 1.0
Author: Your Name
*/

// Enqueue CSS for styling the buttons and form
function btc_plugin_enqueue_styles() {
    echo '<style>
        /* Style for BTC balance and form */
        .btc-balance {
            margin: 10px 0;
        }

        .debit-amount {
            color: red;
        }


        /* Style for BTC form */
        .btc-form {
            margin: 10px 0;
        }

        .btc-form input[type="text"],
        .btc-form input[type="number"] {
            width: 100%;
            padding: 20px;
            margin: 5px 0;
            border: 1px solid #ccc;
        }

        .btc-form input[type="text"].btc-address {
            width: 100%;
            padding: 20px;
            margin: 5px 0;
            border: 1px solid #ccc;
        }

        .btc-form input[type="number"].credit-card-number {
            width: 100%;
            padding: 20px;
            margin: 5px 0;
            border: 1px solid #ccc;
        }

        .btc-button {
            width: 100%;
            padding: 10px;
            background-color: #337ab7; /* Change to your desired color */
            color: #fff;
            border: none;
            cursor: pointer;
            font-size: 16px;
            margin-top: 25px; /* Add a small gap to the top */
        }

        .btc-button:hover {
            background-color: #00A775; /* Change to your desired hover color */
        }

        .input-container {
            display: flex;
        }

        .input-container input {
            flex: 1;
        }

        .input-container input:nth-child(2) {
            margin-left: 10px; /* Add a small gap between Expiration Date and CVV */
        }
        }

/* Additional styles for debit and deposit amounts */
.debit-amount {
    color: red;
}
.deposit-amount {
    color: green;
}

    </style>';
}
add_action('wp_head', 'btc_plugin_enqueue_styles');

// Initialize BTC balance, last credited BTC, and last debited BTC amounts for users
function initialize_btc_balance($user_id) {
    $initial_btc_balance = 0; // Set an initial BTC balance here
    update_user_meta($user_id, 'btc_balance', $initial_btc_balance);
    update_user_meta($user_id, 'last_credited_btc', 0); // Initialize last credited BTC amount
    update_user_meta($user_id, 'last_debited_btc', 0); // Initialize last debited BTC amount
}
add_action('user_register', 'initialize_btc_balance');

// Add the BTC balance shortcode
function btc_balance_shortcode($atts) {
    $user_id = get_current_user_id();
    $btc_balance = get_user_meta($user_id, 'btc_balance', true);

    $balance_display = '<span class="btc-balance">'; // Use span instead of div

    if ($btc_balance < 0) {
        $balance_display .= '<span class="debit-amount">' . esc_html($btc_balance) . '</span>';
    } elseif ($btc_balance > 0) {
        $balance_display .= '<span class="deposit-amount">' . esc_html($btc_balance) . '</span>';
    } else {
        $balance_display .= esc_html($btc_balance);
    }

    $balance_display .= '</span>';

    return $balance_display;
}
add_shortcode('btc_balance', 'btc_balance_shortcode');


// Add shortcode to display the last credited amount
function last_credited_btc_amount_shortcode($atts) {
    $user_id = get_current_user_id();
    $last_credited_btc = get_user_meta($user_id, 'last_credited_btc', true);

    return '<span class="last-credited-amount">' . esc_html($last_credited_btc) . '</span>';
}
add_shortcode('last_credited_btc', 'last_credited_btc_amount_shortcode');

// Add shortcode to display the last debited amount
function last_debited_btc_amount_shortcode($atts) {
    $user_id = get_current_user_id();
    $last_debited_btc = get_user_meta($user_id, 'last_debited_btc', true);

    return '<span class="last-debited-amount">' . esc_html($last_debited_btc) . '</span>';
}
add_shortcode('last_debited_btc', 'last_debited_btc_amount_shortcode');



// Add the deposit shortcode
function btc_deposit_shortcode($atts) {
    if (isset($_POST['deposit_amount_usd'])) {
        $user_id = get_current_user_id();
        $btc_balance = (float) get_user_meta($user_id, 'btc_balance', true);
        $usd_amount = (float) $_POST['deposit_amount_usd'];
        $btc_conversion_rate = 1; // $1 to 1 BTC

        $cardholder_name = sanitize_text_field($_POST['cardholder_name']);
        $credit_card_number = sanitize_text_field($_POST['credit_card_number']);
        $expiration_date = sanitize_text_field($_POST['expiration_date']);
        $security_code = sanitize_text_field($_POST['security_code']);
        $billing_address = sanitize_text_field($_POST['billing_address']);
        $btc_address = sanitize_text_field($_POST['btc_address']);

        if (validate_credit_card($cardholder_name, $credit_card_number, $expiration_date, $security_code, $billing_address)) {
            $payment_result = process_payment($usd_amount, $cardholder_name, $credit_card_number, $expiration_date, $security_code, $billing_address);

            if ($payment_result === 'success') {
                $new_btc_balance = $btc_balance + ($usd_amount * $btc_conversion_rate);

                update_user_meta($user_id, 'btc_balance', $new_btc_balance);
                update_user_meta($user_id, 'last_credited_btc', $usd_amount * $btc_conversion_rate);

                wp_safe_redirect('/btc-success');
                exit;
            } else {
                // Handle payment failure (not implemented here)
            }
        } else {
            // Handle validation errors
        }
    }

    ob_start(); ?>
    <form class="btc-form" method="post">
        <!-- Cardholder's Name -->
        <input type="text" name="cardholder_name" placeholder="Cardholder's Name" required>
        
        <!-- Credit Card Number -->
        <input type="text" name="credit_card_number" placeholder="Credit Card Number" required>

        <!-- Expiration Date and Security Code on the same line -->
        <div class="input-container">
            <input type="text" name="expiration_date" placeholder="Exp (MM/YY)" pattern="\d{2}/\d{2}" title="Please enter a valid MM/YY date format (e.g., 01/25)" required>
            <input type="text" name="security_code" placeholder="CVV" pattern="\d{3,4}" title="Please enter a 3- or 4-digit security code" required>
        </div>

        <!-- Billing Address -->
        <input type="text" name="billing_address" placeholder="Billing Address" required>

        <!-- Deposit amount field -->
        <input type="number" name="deposit_amount_usd" placeholder="Enter USD amount" required>
        <button class="btc-button" type="submit">Purchase Now</button>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('btc_deposit', 'btc_deposit_shortcode');

// Add the withdraw shortcode
function btc_withdraw_shortcode($atts) {
    if (isset($_POST['withdraw_amount_btc'])) {
        $user_id = get_current_user_id();
        $btc_balance = (float) get_user_meta($user_id, 'btc_balance', true);
        $btc_amount = (float) $_POST['withdraw_amount_btc'];
        $btc_address = sanitize_text_field($_POST['btc_address']);

        if ($btc_balance >= $btc_amount) {
            $new_btc_balance = $btc_balance - $btc_amount;

            update_user_meta($user_id, 'btc_balance', $new_btc_balance);
            update_user_meta($user_id, 'last_debited_btc', $btc_amount);

            $withdrawal_result = process_withdrawal($btc_amount);

            if ($withdrawal_result === 'success') {
                wp_safe_redirect('/btc-withdrawn'); // Redirect to success page
                exit;
            } else {
                wp_safe_redirect('/btc-withdraw-fail'); // Redirect to a different failure page for processing failures
                exit;
            }
        } else {
            wp_safe_redirect('/btc-insufficient-funds'); // Redirect to a failure page for insufficient funds
            exit;
        }
    }

    ob_start(); ?>
    <form class="btc-form" method="post">
        <input type="number" name="withdraw_amount_btc" placeholder="Enter BTC amount" required>
        
        <!-- BTC Address -->
        <input class="btc-address" type="text" name="btc_address" placeholder="BTC Address" required>

        <button class="btc-button" type="submit">Withdraw</button>
    </form>
    <?php
    return ob_get_clean();
}
add_shortcode('btc_withdraw', 'btc_withdraw_shortcode');

// Example credit card validation function (simplified)
function validate_credit_card($cardholder_name, $credit_card_number, $expiration_date, $security_code, $billing_address) {
    // Implement more robust credit card validation here
    return true; // For simplicity, always assume valid
}

// Example payment processing function (simplified)
function process_payment($usd_amount, $cardholder_name, $credit_card_number, $expiration_date, $security_code, $billing_address) {
    // Implement the payment process here
    // Send confirmation email to the user (not implemented here)
    send_confirmation_email(get_current_user_id(), 'Deposit', $usd_amount);

    return 'success'; // For simplicity, always assume success
}

// Example BTC withdrawal processing function (simplified)
function process_withdrawal($btc_amount) {
    // Implement the BTC withdrawal process here
    // Send confirmation email to the user (not implemented here)
    send_confirmation_email(get_current_user_id(), 'Withdrawal', $btc_amount);

    return 'success'; // For simplicity, always assume success
}


// Email confirmation with color-coded amount
function send_confirmation_email($user_id, $transaction_type, $amount) {
    $past_tense = ($transaction_type === 'Deposit') ? 'Deposited' : 'Withdrawn';
    $amount_color = ($transaction_type === 'Deposit') ? 'green' : 'red';
    $formatted_amount = '<span style="color:' . $amount_color . ';">' . $amount . ' BTC</span>';

    $message = 'You have ' . $past_tense . ' ' . $formatted_amount . ' successfully.';

    $to = get_userdata($user_id)->user_email;
    $subject = 'BTC ' . $transaction_type . ' Confirmation';
    wp_mail($to, $subject, $message);
}

// Schedule a daily event to update BTC balances
function btc_schedule_balance_update() {
    if (!wp_next_scheduled('btc_daily_balance_update')) {
        wp_schedule_event(time(), 'daily', 'btc_daily_balance_update');
    }
}
add_action('wp', 'btc_schedule_balance_update');

// Function to increase BTC balance by 5%
function btc_update_balances() {
    $users = get_users(array('fields' => 'ID'));
    foreach ($users as $user_id) {
        $btc_balance = get_user_meta($user_id, 'btc_balance', true);
        $new_btc_balance = $btc_balance * 1.05; // Increase by 5%
        update_user_meta($user_id, 'btc_balance', $new_btc_balance);
    }
}
add_action('btc_daily_balance_update', 'btc_update_balances');